#ifndef ZMODELER_STRUCT_SPLINE_H_INCLUDED
#define ZMODELER_STRUCT_SPLINE_H_INCLUDED

//--------------------------------------------------------
// Spline is the sequence of vertices (tVertReference).
// tSplines class is a list of Splines (list of lists).
//--------------------------------------------------------

typedef tVertReference*  tSplineListItem;

//Declaring type of list node
typedef struct tSplineRef
{
  tSplineListItem      Spline;
  tSplineRef*        Next;
}tSpline;

// this struct is only used to back-up and restore splines
// in files and Undo stack.
typedef struct tXYZ
{
  float x,y,z;
}tXYZ;

// each spline's block (in file or Undo stack) has:
typedef struct tSplineBlock
{
  char      Name[MAX_OBJECT_NAMELENGTH];  //name of the spline (unused)
  DWORD      nFlags;    //state: Z3D_FLAG_ combination
  BOOL      Closed;    //TRUE if spline is closed.
  long      NumOfItems;  //amount of tVertex-es in the spline
  //array of indexes in Verts array;
  //this sturcu as well as Verts array is a part
  //of single tSplinesStorage struct.
  long*      Indexes;
}tSplineBlock;

//all splines can be stored in this struct.
typedef struct tSplinesStorage
{
  //amount of splines (tSplineBlock) the Splines pointer is holding
  long      NumOfSplines;
  //amount of vertices (tXYZ) the Verts pointer is holding
  long      NumOfVertices;
  //vertices of all splines. Since different splines can share vertices,
  //all splines uses one set of vertices when storing them;
  //Last index in array is [NumOfVertices-1]
  tXYZ*      Verts;
  //array of descriptors of spines. Last index is [NumOfSplines-1];
  tSplineBlock*  Splines;
}tSplinesStorage;



//Declaring type ListPointer
typedef tSplineRef*  tSplineList;

//---------------------------------------------------------
// tSplines class is a list of Splines (list of lists).
//---------------------------------------------------------
class DllExport tSplines
{
//------------------------
//  data members
  tSplineList      ListHead;

public:
  tNormVertListItem  ActiveVertex;
  tSplineList      ActiveSpline;
  tSplineList      SplineOperands[MAX_SPLINE_OPERANDS];

  BOOL  NeedAlternativeDraw;

//------------------------------
//  construction/deconstruction
  tSplines();
  ~tSplines();
  
//------------------------
//  functions
  tSplineList      GetListHead() {return ListHead;}
  void        SetListHead(tSplineList Head) {ListHead = Head;}

  tNormVertListItem EdgeClick(
            tSplineList &InSpline,
            POINT *loc,
            z3dViewDescriptor* pView);
  void SafeDelete(tSplineListItem &Spl);
  void MapAllVert(tNormVertListItem tmp, tNormVertListItem pnew);
  void DeleteVertexFromSplines(BOOL MarkedMode, BOOL Selection);
  void DeleteSplines(BOOL MarkedMode, BOOL Selection);
  void SafeDeleteVert(tNormVertListItem Vert);
  void AddIntermediate(tPOINT p);
  void MoveIntermediateOffset(tPOINT *Offset);
  void MoveIntermediate(tPOINT *Offset);
  void ResetOperands();
  
  void EnableAllVerts();
  tNormVertListItem  GetMarkedVertex(BOOL NotActive);

  void SetOperands(int Op, tSplineList val);
  BOOL IsValidOperands();
  long    IndexOfSpline(tSplineList spl);
  tSplineList SplineByIndex(long index);


  tSplineList CreateNewSpline();
  tSplineList CreateNewSpline(char* name, DWORD f, void* pCustomD, void* pDelProc, void* pUndoProc);

  tSplineList GetLastSpline();
  tSplineListItem GetActiveSpline();
  // finds an already existed vertex to close spline
  // even connecting to other.
  tNormVertListItem FindCloseMatch(
                    tSplineList *InSpline,
                    POINT *loc,
                    z3dViewDescriptor* pView,
                    BOOL  Intermediate);//FALSE means only start and end verts
  void CheckForUnition(  POINT *loc,
                        z3dViewDescriptor* pView);

  void UnClockWiseSpline(tSplineListItem Spline, z3dViewDescriptor* pView);

  //////////////////////////////////////////////
  //  Savements and Restorements
  //////////////////////////////////////////////
  long FullIndexate(tVertReference** Result);
  long GetAmountOfSplines();
  tSplinesStorage*  StoreSplines();
  void RestoreSplines(tSplinesStorage*  storage);

  void DeleteLastSpline();
  void DeleteEmptySplines();
  void DeleteList();
  void AlternativeDraw(
            CWnd *Wnd,
            z3dViewDescriptor* pView);

  virtual void Draw(  CDC* pDC,
            z3dViewDescriptor* pView, BOOL  DrawMarked);
  virtual BOOL Cover(  POINT *loc,
            z3dViewDescriptor* pView,
            long CoverRadius);
  /****************************************
        M O D I F E R S
  ****************************************/
  void Rotate (
      z3dViewDescriptor* pView, float Angle, BOOL MarkedMode, BOOL Selection);
  void Mirror (z3dViewDescriptor* pView, BOOL MarkedMode, BOOL Selection);
  void MoveOffset (tPOINT *Offset, BOOL MarkedMode, BOOL Selection);
  void Scale(float XScale, float YScale, float ZScale, BOOL MarkedMode, BOOL Selection);
};

#endif

